
/****** Object:  UserDefinedFunction [dbo].[UFD_SINTEGRA_REG_75]    Script Date: 03/25/2013 09:43:56 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_SINTEGRA_REG_75]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_SINTEGRA_REG_75]
GO

/*    
 Busca os produtos movimentados não interessando seu tipo de movimento    
 ou seja entrada ou saida de uma determinada filial    
    
 EMPRESA:     
 DATA INICIO:  08/05/2004    
 DATA TERMINO: 08/05/2004     
 PROFISSIONAL: Cristiano Nunes da Silva    
*/  
--versao 2591  
--SELECT  * FROM UFD_SINTEGRA_REG_75 (1,1014,'2016-02-01','2016-02-29','2015-12-31') WHERE CD_PROD  = 2315    
--ALTER  FUNCTION UFD_SINTEGRA_REG_75(    
CREATE      FUNCTION [dbo].[UFD_SINTEGRA_REG_75](    
    
               @CD_EMP  INT,    
               @CD_FILIAL   VARCHAR(MAX),    
               @DT_INI      DATETIME,    
               @DT_FIM      DATETIME,
			   @DT_REF_INVENTARIO DATETIME)    

RETURNS @EST_PROD_MOV TABLE (    
           CD_PROD   INT,    
           DS_PROD  VARCHAR(300),    
           DS_UN    VARCHAR(10),    
           NR_NCM   VARCHAR(50),
		   DOC      VARCHAR(50),
		   CD_BARRA VARCHAR(20))    
AS    
BEGIN    
  
   
DECLARE @RS_PROD TABLE (CD_EMP INT, CD_PROD INT,DOC VARCHAR(50))    
    
INSERT INTO @RS_PROD    
SELECT         
	EST_NF_SAI_IT.CD_EMP,    
	EST_NF_SAI_IT.CD_PROD,
	'NF SAIDA' AS DOC   
FROM             
	 EST_NF_SAI INNER JOIN  EST_NF_SAI_IT ON
	 EST_NF_SAI.CD_EMP = EST_NF_SAI_IT.CD_EMP AND     
	 EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT.CD_FILIAL AND     
	 EST_NF_SAI.CD_NF = EST_NF_SAI_IT.CD_NF AND
	 EST_NF_SAI.DT_EMI_NF = EST_NF_SAI_IT.DT_EMI_NF
	 INNER JOIN GLB_MOV_OP ON
	 EST_NF_SAI.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP 
WHERE     
 EST_NF_SAI_IT.CD_EMP = @CD_EMP     
 AND EST_NF_SAI_IT.CD_FILIAL  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL ))     
 AND EST_NF_SAI_IT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM    
 AND EST_NF_SAI.STS_NF= 0  
 AND GLB_MOV_OP.TP_MOV NOT IN (28,29,32)  
UNION    
SELECT    
	 EST_NF_ENT_IT.CD_EMP,         
	 EST_NF_ENT_IT.CD_PROD,
	'NF ENTRADA' AS DOC
FROM             
	EST_NF_ENT INNER JOIN EST_NF_ENT_IT ON
	EST_NF_ENT.CD_EMP = EST_NF_ENT_IT.CD_EMP AND     
	EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT.CD_FILIAL AND     
	EST_NF_ENT.CD_NF = EST_NF_ENT_IT.CD_NF AND
	EST_NF_ENT.DT_ENT = EST_NF_ENT_IT.DT_ENT 
	INNER JOIN GLB_MOV_OP ON
	EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP 
WHERE     
 EST_NF_ENT_IT.CD_EMP = @CD_EMP     
 AND EST_NF_ENT_IT.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL ))   
 AND EST_NF_ENT_IT.DT_ENT BETWEEN @DT_INI AND @DT_FIM   
 AND STS_NF = 0  
 AND GLB_MOV_OP.TP_MOV NOT IN (29,32)  
UNION    
SELECT         
 PDV_VD_IT.CD_EMP,    
 PDV_VD_IT.CD_PROD,
 'CUPOM FISCAL' AS DOC
FROM             
	PDV_VD INNER JOIN PDV_VD_IT ON
	PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND
	PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
	PDV_VD.CD_VD = PDV_VD_IT.CD_VD AND
	PDV_VD.DT_VD = PDV_VD_IT.DT_VD    
	INNER JOIN PDV_CX ON 
	PDV_VD.CD_EMP  	= PDV_CX.CD_EMP 	AND
	PDV_VD.CD_FILIAL = PDV_CX.CD_FILIAL	AND
	PDV_VD.CD_CX  = PDV_CX.CD_CX   
WHERE         
	 PDV_VD_IT.CD_EMP = @CD_EMP    
	 AND PDV_VD_IT.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))    
	 AND PDV_VD_IT.DT_VD BETWEEN @DT_INI AND @DT_FIM    
	 AND PDV_VD.TIPO = 0
	 AND PDV_VD.ST_VD = 0  
	 AND PDV_VD_IT.ST_IT = 1
     AND PDV_CX.EXPORT=0
	AND ISNULL(PDV_VD.FLAG_NFCE,0) = 0


UNION    
SELECT    
 CD_EMP,    
 CD_PROD,
 'INVENTARIO' AS DOC
FROM    
 EST_PROD_INVENTARIO    
WHERE    
 CD_EMP = @CD_EMP    
 AND CD_FILIAL  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))    
 AND DT_REF BETWEEN @DT_REF_INVENTARIO AND @DT_REF_INVENTARIO     
 AND QT_EST > 0
    
INSERT INTO @EST_PROD_MOV    
SELECT         
	DISTINCT EST_PROD.CD_PROD,     
	LEFT(EST_PROD.DS_PROD,100) AS DS_PROD,     
	EST_PROD_UN_MED.DS_UN,    
    EST_PROD.NR_NCM,
	DOC,
	(SELECT TOP 1 MAX(CD_BARRA) AS CD_BARRA  
	FROM EST_PROD_CD_BARRA 
	WHERE CD_EMP = RS_PROD.CD_EMP 
	AND CD_PROD = RS_PROD.CD_PROD) AS CD_BARRA  
FROM    
 EST_PROD INNER JOIN @RS_PROD RS_PROD ON      
 EST_PROD.CD_EMP = RS_PROD.CD_EMP AND     
 EST_PROD.CD_PROD = RS_PROD.CD_PROD 
 INNER JOIN EST_PROD_UN_MED ON
 EST_PROD.CD_EMP = EST_PROD_UN_MED.CD_EMP AND     
 EST_PROD.CD_UN_VD = EST_PROD_UN_MED.CD_CTR_UN    
ORDER BY     
 EST_PROD.CD_PROD    
RETURN    
END 
